////////////////////////////////////////////////////////////////////////////////////////////////////////
// Social Media ObjC code for use with Cocos2D-X
//
// Currently supports Facebook SDK for posting a link to a users Facebook feed.
// Suggested use is to
// (1) Check Facebook is supported on the users device (iOS and Facebook app present).
// (2) Prompt the user with a nice message like "Let people know about this game. Post 'Hey check out this game'" on Facebook.
// (3) Post the messgae to facebook (if this is the first time the user will be prompted with a system dialog saying "Let Game access your Facebook info".
// (4) Done. Check getFacebookPostingState later to see if the post was a success or not.
//
// Gavin M Thornton
//
// See for more info:  https://developers.facebook.com/docs/howtos/publish-to-feed-ios-sdk/
////////////////////////////////////////////////////////////////////////////////////////////////////////

#import "KamCord-objc.h"
#import <Kamcord/Kamcord.h>

//#import "../Reachability/Reachability.h"

@implementation KamCordIntObjC

////////////////////////////////////////////////////////////////////////////////////////////////////////
- (void) Init
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
- (void) record
{
    [Kamcord startRecording];
}
////////////////////////////////////////////////////////////////////////////////////////////////////////
- (void) stop
{
    [Kamcord stopRecording];
}
////////////////////////////////////////////////////////////////////////////////////////////////////////
- (void) pause
{
    [Kamcord pause];
}
////////////////////////////////////////////////////////////////////////////////////////////////////////
- (void) resume
{
    [Kamcord resume];
}
////////////////////////////////////////////////////////////////////////////////////////////////////////
- (void) show
{
    [Kamcord showView];
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
- (void) showWatchView
{
    [Kamcord showWatchView];
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
- (void) setVideoTitle:(NSString *)title
{
    [Kamcord setVideoTitle:title];
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
- (void) setVideoInfo:(NSString *)LevelName score:(unsigned int)iScore
        youtubeDesc:(NSString *)YTd youtubeTags:(NSString *)YTt
        facebookDesc:(NSString *)FBd
        //twitterTweet:(NSString *)TWt twitterDesc:(NSString *)TWd
{
//    [Kamcord fireTestNotification];
    
    [Kamcord setLevel:LevelName
            score:[NSNumber numberWithInt:iScore]];
    
    [Kamcord setYouTubeDescription:YTd tags:YTt];
    [Kamcord setFacebookDescription:FBd];
    
//    + (void)fireTestNotification;
//    [Kamcord setDefaultTweet:@"TWITTER TWEET"];
//    [Kamcord setTwitterDescription:@"TWITTER DESCRIPTION"];
//    
//    [Kamcord setDefaultEmailSubject:@"EMAIL SUBJECT"];
//    [Kamcord setDefaultEmailBody:@"EMAIL BODY"];

//+ (void)setFacebookAppID:(NSString *)facebookAppID;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
- (void) showKamCordViewer
{
    [Kamcord showView];
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
@end
////////////////////////////////////////////////////////////////////////////////////////////////////////
